require( "scripts/style.lua" );

NameFont = {
  standardFont,
  20,
  BlackColor
};

HeaderFont = {
  standardFont,
  48,
  BlackColor
};

ButtonX = kCenter;
ButtonY = 90;
ButtonYSpace = 30;


-- BOGUS? what's the last image for?
MapButtonGraphics1 = 
{
	"images/metamap/blank",
	"images/metamap/metamap_venue1_hit",
	"images/metamap/metamap_venue1_over",
	"images/metamap/blank"
};	

MapButtonGraphics2 = 
{
	"images/metamap/metamap_venue2_active",
	"images/metamap/metamap_venue2_hit",
	"images/metamap/metamap_venue2_over",
	"images/metamap/blank"
};	

MapButtonGraphics3 = 
{
	"images/metamap/metamap_venue3_active",
	"images/metamap/metamap_venue3_hit",
	"images/metamap/metamap_venue3_over",
	"images/metamap/blank"
};	

MapButtonGraphics4 = 
{
	"images/metamap/metamap_venue4_active",
	"images/metamap/metamap_venue4_hit",
	"images/metamap/metamap_venue4_over",
	"images/metamap/blank"
};	

MapButtonGraphics5 = 
{
	"images/metamap/metamap_venue5_active",
	"images/metamap/metamap_venue5_hit",
	"images/metamap/metamap_venue5_over",
	"images/metamap/blank"
};	

config = {
	showAll="no";
	gameMode="arcade";
}

MapStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
--	graphics = MapButtonGraphics,
	sound = kDefaultButtonSound
};

PlayDefaultButtonGraphics = {
	"buttons/highscores_btn_purp_idle.png",
	"buttons/highscores_btn_purp_down.png",
	"buttons/highscores_btn_purp_hl.png"
};

PlayDefaultFont = {
  standardFont,
  36,
  DarkPurpleColor
};

curVenue = GetCurrentVenue()

MakeDialog
{
	Bitmap
	{
		image="images/MetaMap/MetaMap_BG",
		x=kCenter,
		y=kCenter,
	
	--[[	
		Text
			{
				font = HeaderFont,
				name = "title",
				x=kCenter,y=40,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "gamemode2"
			};
		]]--
			
		MetaMap
		{
			x = 0, y = 0, w=kMax, h=kMax,
			
			SetStyle(MapStyle);
			--BeginGroup();
-- venue 1
			Button {
				name="button1",
				x = 82, y = 385,
				rolloversound = "assets/audio/sfx/meta_map_roll.ogg",
				sound = "assets/audio/sfx/meta_map_click.ogg",
				graphics = MapButtonGraphics1;

				command = 
					function()
						ToLevel(1,1);
					end
			};
			
			
-- venue 2
			Button {
				name="button2",
				x = 105, y = 288,
				rolloversound = "assets/audio/sfx/meta_map_roll.ogg",
				sound = "assets/audio/sfx/meta_map_click.ogg",
				graphics = MapButtonGraphics2;

				command = 
					function()
						ToLevel(2,1);
					end
			};
			
-- venue 3
			Button {
				name="button3",
				x = 133, y = 219,
				rolloversound = "assets/audio/sfx/meta_map_roll.ogg",
				sound = "assets/audio/sfx/meta_map_click.ogg",
				graphics = MapButtonGraphics3;

				command = 
					function()
						ToLevel(3,1);
					end
			};			
			
-- venue 4
			Button {
				name="button4",
				x = 162, y = 143,
				rolloversound = "assets/audio/sfx/meta_map_roll.ogg",
				sound = "assets/audio/sfx/meta_map_click.ogg",
				graphics = MapButtonGraphics4;

				command = 
					function()
						ToLevel(4,1);
					end
			};
			
			
--venue 5
			Button {
				name="button5",
				x = 207, y = 7,
				rolloversound = "assets/audio/sfx/meta_map_roll.ogg",
				sound = "assets/audio/sfx/meta_map_click.ogg",
				graphics = MapButtonGraphics5;

				command = 
					function()
						ToLevel(5,1);
					end
			};
			
			
			--SetStyle(DefaultStyle);

			Button{
				x=20,
				y=550,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="back",
				label="common.back.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    PopModal();
					    SwapToModal("ui_scripts/screens/main_menu_scrn.lua");
					end
				
			};
			
			Button{
				x=540,
				y=540,
				font = PlayDefaultFont,
				graphics = PlayDefaultButtonGraphics,
				name = "play",
				label = "common.play.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()						
						ToLevel(curVenue, 1);
					end
				
			};
	
		}
	}
}